/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.ui.bonsai.event;

import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.ui.bonsai.event.Event;
import com.ibm.hwmca.ui.bonsai.event.EventQueueListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class EventQueue {
    public static final long DEFAULT_WAIT_BEFORE_EMPTY_NOTIFY = 500L;
    private static final String TRACEMASK_T = "XBUIEVQT";
    private static final String TRACEMASK_F = "XBUIEVQF";
    private static final String TRACEMASK_D = "XBUIEVQD";
    private final Object NOTIFY_LOCK = new Object();
    private String id;
    private List queue;
    private Set queueListeners;
    private long waitBeforeEmptyNotify;

    public EventQueue(String id, long waitBeforeEmptyNotify) {
        Trace.trace(TRACEMASK_T, "<--> EventQueue(" + id + ", " + waitBeforeEmptyNotify + ")");
        this.id = id;
        this.queue = new ArrayList();
        this.queueListeners = new HashSet();
        this.waitBeforeEmptyNotify = waitBeforeEmptyNotify;
        new EventNotificationMonitor().start();
    }

    public EventQueue(String id) {
        this(id, 500L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(Event event) {
        Trace.trace(TRACEMASK_D, "<--> EventQueue.enqueue(" + event + ")");
        Object object = this.queue;
        synchronized (object) {
            this.queue.add(event);
        }
        object = this.NOTIFY_LOCK;
        synchronized (object) {
            this.NOTIFY_LOCK.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventQueueListener(EventQueueListener listener) {
        Set set = this.queueListeners;
        synchronized (set) {
            this.queueListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventQueueListener(EventQueueListener listener) {
        Set set = this.queueListeners;
        synchronized (set) {
            this.queueListeners.remove(listener);
        }
    }

    private class EventNotificationMonitor
    extends Thread {
        public EventNotificationMonitor() {
            super(EventQueue.this.id + ".EventMonitor");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                Object object = EventQueue.this.NOTIFY_LOCK;
                synchronized (object) {
                    try {
                        EventQueue.this.NOTIFY_LOCK.wait();
                    }
                    catch (InterruptedException iEx) {
                        // empty catch block
                    }
                }
                Event event = null;
                while (true) {
                    if (!EventQueue.this.queue.isEmpty()) {
                        List iEx = EventQueue.this.queue;
                        synchronized (iEx) {
                            event = (Event)EventQueue.this.queue.remove(0);
                        }
                        try {
                            event.notifyListeners();
                        }
                        catch (Throwable th) {
                            Trace.trace(EventQueue.TRACEMASK_F, "Event notification failed: " + th.toString());
                            th.printStackTrace();
                        }
                        continue;
                    }
                    Object object2 = EventQueue.this.NOTIFY_LOCK;
                    synchronized (object2) {
                        try {
                            EventQueue.this.NOTIFY_LOCK.wait(EventQueue.this.waitBeforeEmptyNotify);
                        }
                        catch (InterruptedException iEx) {
                            // empty catch block
                        }
                        if (EventQueue.this.queue.isEmpty()) {
                            Set iEx = EventQueue.this.queueListeners;
                            synchronized (iEx) {
                                Iterator i = EventQueue.this.queueListeners.iterator();
                                while (i.hasNext()) {
                                    ((EventQueueListener)i.next()).queueEmpty();
                                }
                            }
                            try {
                                EventQueue.this.NOTIFY_LOCK.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
            catch (Throwable th) {
                Trace.trace(EventQueue.TRACEMASK_F, "Monitor thread dying from exception: " + th.toString());
                th.printStackTrace();
                return;
            }
        }
    }
}

